*********************************************************
* This program uses output from Rage-rgequate to create *
*   graphs like those in Figure 3.4 on page 78 of Kolen *
*   and Brennan (the example data is from the example   *
*   file input.dat).  This program will work with any   *
*   set of C values.  You must indicate the number of C *
*   levels you used and specify the specific C values.  *
*   Paste in your output where indicated.               *
*                                     -Brett Foley      *
*********************************************************;
*********************************************************
* Minor changes have been made from Brett's orignal SAS *
*   codes such that the final codes could be generated  *
*   by Rage-Rgequate automatically.                     *
*                                     -Zhongmin Cui     *
*********************************************************;

*------------------------------------* 
| Enter the number of C levels here. |
*------------------------------------*;
%LET numlevels = 
10
;

*------------------------------------*
| Enter the C values here (separated |
|   by spaces).                      |
*------------------------------------*;
%LET levels = 
1 2 3 4 5 6 7 8 9 10 
;


*-----------------------------------------------------*
| Paste Smoothed distribution Data for Form X (or Y)  |
|   output here. (after "datalines" command)          |
*-----------------------------------------------------*;
data preplots;
input Score Raw c1-c&numlevels Beta; 
datalines;

0          0.0000000 0.0078034 0.0000043 0.0000133 0.0000000 0.0000024 0.0000066 0.0001011 0.0001054 0.0000429 0.0000369 0.0000000
1          0.0000000 0.0079390 0.0000068 0.0000190 0.0000000 0.0000037 0.0000080 0.0000460 0.0000415 0.0000135 0.0000166 0.0000000
2          0.0000000 0.0080770 0.0000105 0.0000271 0.0000001 0.0000056 0.0000101 0.0000280 0.0000233 0.0000072 0.0000106 0.0000000
3          0.0000001 0.0082173 0.0000162 0.0000382 0.0000004 0.0000086 0.0000133 0.0000216 0.0000174 0.0000058 0.0000089 0.0000001
4          0.0000004 0.0083601 0.0000247 0.0000536 0.0000011 0.0000133 0.0000182 0.0000202 0.0000163 0.0000062 0.0000093 0.0000003
5          0.0000014 0.0085054 0.0000371 0.0000748 0.0000026 0.0000206 0.0000255 0.0000220 0.0000181 0.0000081 0.0000115 0.0000010
6          0.0000041 0.0086532 0.0000552 0.0001036 0.0000059 0.0000318 0.0000365 0.0000270 0.0000228 0.0000121 0.0000160 0.0000032
7          0.0000105 0.0088036 0.0000812 0.0001424 0.0000127 0.0000491 0.0000530 0.0000362 0.0000316 0.0000198 0.0000241 0.0000085
8          0.0000238 0.0089566 0.0001179 0.0001944 0.0000259 0.0000752 0.0000777 0.0000516 0.0000467 0.0000338 0.0000385 0.0000201
9          0.0000493 0.0091122 0.0001694 0.0002636 0.0000501 0.0001143 0.0001144 0.0000768 0.0000720 0.0000585 0.0000632 0.0000435
10         0.0000943 0.0092706 0.0002406 0.0003547 0.0000924 0.0001720 0.0001684 0.0001173 0.0001132 0.0001009 0.0001048 0.0000863
11         0.0001689 0.0094317 0.0003378 0.0004737 0.0001624 0.0002559 0.0002472 0.0001814 0.0001791 0.0001710 0.0001726 0.0001592
12         0.0002858 0.0095956 0.0004688 0.0006278 0.0002734 0.0003760 0.0003604 0.0002805 0.0002821 0.0002821 0.0002799 0.0002758
13         0.0004600 0.0097623 0.0006432 0.0008256 0.0004417 0.0005446 0.0005208 0.0004304 0.0004384 0.0004507 0.0004433 0.0004521
14         0.0007090 0.0099320 0.0008725 0.0010773 0.0006866 0.0007770 0.0007439 0.0006508 0.0006679 0.0006959 0.0006829 0.0007062
15         0.0010516 0.0101046 0.0011699 0.0013943 0.0010297 0.0010913 0.0010487 0.0009653 0.0009937 0.0010381 0.0010206 0.0010571
16         0.0015077 0.0102802 0.0015507 0.0017899 0.0014932 0.0015079 0.0014568 0.0013995 0.0014404 0.0014978 0.0014785 0.0015242
17         0.0020967 0.0104588 0.0020321 0.0022786 0.0020989 0.0020487 0.0019917 0.0019797 0.0020317 0.0020940 0.0020771 0.0021257
18         0.0028370 0.0106406 0.0026325 0.0028764 0.0028660 0.0027363 0.0026776 0.0027295 0.0027884 0.0028434 0.0028336 0.0028780
19         0.0037443 0.0108255 0.0033714 0.0035999 0.0038097 0.0035921 0.0035377 0.0036674 0.0037259 0.0037594 0.0037608 0.0037948
20         0.0048311 0.0110136 0.0042684 0.0044662 0.0049396 0.0046351 0.0045919 0.0048044 0.0048528 0.0048519 0.0048665 0.0048861
21         0.0061049 0.0112050 0.0053423 0.0054919 0.0062590 0.0058794 0.0058550 0.0061427 0.0061704 0.0061266 0.0061537 0.0061575
22         0.0075680 0.0113997 0.0066100 0.0066926 0.0077644 0.0073328 0.0073339 0.0076753 0.0076730 0.0075851 0.0076207 0.0076102
23         0.0092165 0.0115978 0.0080851 0.0080814 0.0094454 0.0089951 0.0090269 0.0093871 0.0093485 0.0092242 0.0092620 0.0092401
24         0.0110404 0.0117993 0.0097764 0.0096682 0.0112856 0.0108574 0.0109219 0.0112565 0.0111803 0.0110358 0.0110680 0.0110382
25         0.0130232 0.0120044 0.0116866 0.0114581 0.0132633 0.0129013 0.0129971 0.0132577 0.0131482 0.0130060 0.0130254 0.0129901
26         0.0151422 0.0122130 0.0138104 0.0134500 0.0153528 0.0150997 0.0152213 0.0153628 0.0152302 0.0151153 0.0151164 0.0150765
27         0.0173698 0.0124252 0.0161338 0.0156357 0.0175258 0.0174176 0.0175558 0.0175433 0.0174023 0.0173382 0.0173189 0.0172737
28         0.0196736 0.0126411 0.0186329 0.0179987 0.0197519 0.0198138 0.0199563 0.0197716 0.0196399 0.0196438 0.0196059 0.0195532
29         0.0220178 0.0128608 0.0212733 0.0205130 0.0220004 0.0222431 0.0223758 0.0220211 0.0219168 0.0219961 0.0219453 0.0218832
30         0.0243645 0.0130843 0.0240104 0.0231433 0.0242404 0.0246583 0.0247673 0.0242661 0.0242055 0.0243556 0.0243006 0.0242287
31         0.0266744 0.0133117 0.0267903 0.0258445 0.0264418 0.0270127 0.0270853 0.0264816 0.0264761 0.0266805 0.0266313 0.0265524
32         0.0289087 0.0135430 0.0295506 0.0285626 0.0285752 0.0292619 0.0292886 0.0286415 0.0286965 0.0289285 0.0288946 0.0288152
33         0.0310293 0.0137784 0.0322231 0.0312361 0.0306121 0.0313653 0.0313410 0.0307189 0.0308320 0.0310585 0.0310470 0.0309776
34         0.0330001 0.0140178 0.0347360 0.0337973 0.0325250 0.0332875 0.0332119 0.0326844 0.0328456 0.0330323 0.0330463 0.0329999
35         0.0347875 0.0142614 0.0370173 0.0361757 0.0342867 0.0349983 0.0348764 0.0345059 0.0346982 0.0348152 0.0348530 0.0348437
36         0.0363608 0.0145092 0.0389978 0.0383002 0.0358706 0.0364733 0.0363150 0.0361490 0.0363504 0.0363772 0.0364325 0.0364723
37         0.0376923 0.0147614 0.0406151 0.0401027 0.0372501 0.0376936 0.0375124 0.0375775 0.0377633 0.0376927 0.0377558 0.0378518
38         0.0387576 0.0150179 0.0418164 0.0415218 0.0383988 0.0386446 0.0384567 0.0387541 0.0389007 0.0387405 0.0388000 0.0389520
39         0.0395357 0.0152788 0.0425615 0.0425058 0.0392906 0.0393157 0.0391383 0.0396430 0.0397303 0.0395031 0.0395481 0.0397471
40         0.0400087 0.0155444 0.0428252 0.0430160 0.0399000 0.0396992 0.0395490 0.0402110 0.0402264 0.0399661 0.0399881 0.0402162
41         0.0401624 0.0158145 0.0425984 0.0430292 0.0402028 0.0397898 0.0396810 0.0404308 0.0403706 0.0401174 0.0401123 0.0403442
42         0.0399862 0.0160893 0.0418889 0.0425389 0.0401768 0.0395836 0.0395268 0.0402825 0.0401532 0.0399472 0.0399160 0.0401226
43         0.0394737 0.0163689 0.0407208 0.0415567 0.0398038 0.0390783 0.0390790 0.0397559 0.0395738 0.0394482 0.0393971 0.0395490
44         0.0386234 0.0166534 0.0391331 0.0401114 0.0390704 0.0382726 0.0383308 0.0388522 0.0386411 0.0386164 0.0385552 0.0386284
45         0.0374398 0.0169427 0.0371779 0.0382478 0.0379704 0.0371674 0.0372771 0.0375840 0.0373720 0.0374521 0.0373929 0.0373728
46         0.0359335 0.0172372 0.0349170 0.0360244 0.0365062 0.0357661 0.0359159 0.0359753 0.0357909 0.0359618 0.0359162 0.0358013
47         0.0341229 0.0175367 0.0324191 0.0335104 0.0346911 0.0340762 0.0342505 0.0340605 0.0339282 0.0341602 0.0341368 0.0339401
48         0.0320345 0.0178415 0.0297561 0.0307819 0.0325505 0.0321109 0.0322910 0.0318825 0.0318188 0.0320713 0.0320740 0.0318217
49         0.0297034 0.0181515 0.0270000 0.0279180 0.0301230 0.0298907 0.0300576 0.0294899 0.0295010 0.0297303 0.0297571 0.0294852
50         0.0271731 0.0184669 0.0242193 0.0249970 0.0274601 0.0274453 0.0275816 0.0269354 0.0270156 0.0271830 0.0272265 0.0269746
51         0.0244951 0.0187879 0.0214769 0.0220925 0.0246258 0.0248152 0.0249075 0.0242726 0.0244056 0.0244849 0.0245342 0.0243389
52         0.0217273 0.0191143 0.0188275 0.0192706 0.0216937 0.0220519 0.0220929 0.0215548 0.0217160 0.0216995 0.0217428 0.0216301
53         0.0189323 0.0194465 0.0163165 0.0165875 0.0187438 0.0192180 0.0192076 0.0188335 0.0189944 0.0188940 0.0189216 0.0189027
54         0.0161749 0.0197844 0.0139789 0.0140877 0.0158576 0.0163848 0.0163299 0.0161578 0.0162914 0.0161362 0.0161431 0.0162119
55         0.0135184 0.0201282 0.0118394 0.0118037 0.0131131 0.0136290 0.0135425 0.0135747 0.0136606 0.0134898 0.0134767 0.0136117
56         0.0110225 0.0204780 0.0099128 0.0097555 0.0105791 0.0110274 0.0109256 0.0111294 0.0111577 0.0110112 0.0109844 0.0111539
57         0.0087392 0.0208339 0.0082050 0.0079520 0.0083101 0.0086503 0.0085501 0.0088652 0.0088388 0.0087468 0.0087157 0.0088855
58         0.0067098 0.0211959 0.0067138 0.0063920 0.0063425 0.0065549 0.0064705 0.0068226 0.0067561 0.0067317 0.0067061 0.0068468
59         0.0049628 0.0215643 0.0054309 0.0050662 0.0046932 0.0047794 0.0047199 0.0050379 0.0049534 0.0049899 0.0049765 0.0050698
60         0.0035123 0.0219390 0.0043430 0.0039586 0.0033590 0.0033388 0.0033072 0.0035390 0.0034597 0.0035338 0.0035342 0.0035758
61         0.0023568 0.0223203 0.0034333 0.0030490 0.0023199 0.0022244 0.0022180 0.0023404 0.0022841 0.0023653 0.0023759 0.0023735
62         0.0014804 0.0227081 0.0026832 0.0023145 0.0015421 0.0014063 0.0014183 0.0014389 0.0014128 0.0014747 0.0014886 0.0014577
63         0.0008544 0.0231028 0.0020730 0.0017315 0.0009840 0.0008392 0.0008614 0.0008101 0.0008107 0.0008401 0.0008506 0.0008079
64         0.0004398 0.0235042 0.0015833 0.0012763 0.0006011 0.0004700 0.0004949 0.0004103 0.0004268 0.0004264 0.0004302 0.0003890
65         0.0001920 0.0239127 0.0011955 0.0009268 0.0003506 0.0002456 0.0002678 0.0001830 0.0002037 0.0001866 0.0001849 0.0001528
66         0.0000644 0.0243282 0.0008923 0.0006630 0.0001946 0.0001189 0.0001359 0.0000701 0.0000870 0.0000675 0.0000640 0.0000435
67         0.0000126 0.0247510 0.0006584 0.0004671 0.0001025 0.0000530 0.0000644 0.0000224 0.0000328 0.0000191 0.0000166 0.0000067

;
run;

*!!!!!!!!!!!!!!!!!!!!DANGER!!!!!!!!!!!!!!!!!!!!!!!*
!        Do not alter code below this point!      !
*!!!!!!!!!!!!!!!!!!!!DANGER!!!!!!!!!!!!!!!!!!!!!!!*;

*This reformats the data (tall format);
data preplots_reformatted; set preplots;

array testarray1 [&numlevels] c1-c&numlevels;
array x1[&numlevels] y1-y&numlevels (&levels);

do i = 1 to &numlevels;
clevel=i; eqvalue=testarray1[i]; C_Value = x1[i]; output;
end;
keep Score Raw clevel eqvalue C_Value;
run;


**************************
* Formatting for graphs  *
**************************;

*This deletes the contents of the default graphics catalog work.gseg;
proc greplay nofs igout=work.gseg; delete _all_; run; quit;

*This creates axis labels;
axis1 label = (font=swiss height=1 'Raw Score');
axis2 label = (angle=90 font=swiss height=1 'Relative Frequency');

*This sets up legends for the graphs;
legend1 label=none
        shape=symbol(7,1)
        position=(top center inside)
		value=('Smoothed' 'Raw')
        mode=share;


*******************************************
* This prints 1 graph per page (looks best*
*   printed in landscape format)          *
*******************************************;
proc sort; by C_Value; run;

options nobyline;
proc gplot data=preplots_reformatted;
   by C_Value;
   plot eqvalue*Score Raw*Score 
        /overlay haxis=axis1 vaxis=axis2 legend=legend1;
        symbol1 color=red   i=line v=square h=1;
		symbol2 color=black i=line v=diamond h=1;
        title 'Presmoothing Distribution, C = #byval(C_Value)';
run; quit;

proc gplot data=preplots;
   plot Beta*Score Raw*Score 
        /overlay haxis=axis1 vaxis=axis2 legend=legend1;
        symbol1 color=red   i=line v=square h=1;
		symbol2 color=black i=line v=diamond h=1;
        title 'Presmoothing Distribution, Beta4';
run; quit;

*******************************************
* This prints multiple graphs on a single *
*  sheet (4 graphs per page), print in    *
*  landscape format.                      *
*******************************************;

*This makes sure we print the correct number of graphs;
%macro setup4graphs;
    %if (&numlevels LE 3) %then %do;
        treplay 1:Gplot  2:Gplot1 3:Gplot2 4:Gplot3; 
    %end;
    %else %if (&numlevels LE 7) %then %do;
        treplay 1:Gplot   2:Gplot1 3:Gplot2 4:Gplot3; 
        treplay 1:Gplot4  2:Gplot5 3:Gplot6 4:Gplot7;
	%end;
	%else %if (&numlevels LE 11) %then %do;
        treplay 1:Gplot   2:Gplot1 3:Gplot2  4:Gplot3; 
        treplay 1:Gplot4  2:Gplot5 3:Gplot6  4:Gplot7;
        treplay 1:Gplot8  2:Gplot9 3:Gplot10 4:Gplot11;
    %end;
	%else %if (&numlevels LE 15) %then %do;
        treplay 1:Gplot    2:Gplot1  3:Gplot2  4:Gplot3; 
        treplay 1:Gplot4   2:Gplot5  3:Gplot6  4:Gplot7;
		treplay 1:Gplot8   2:Gplot9  3:Gplot10 4:Gplot11;
		treplay 1:Gplot12  2:Gplot13 3:Gplot14 4:Gplot15;
	%end;
%mend;

*This prints the graphs;
proc greplay igout=work.gseg tc=work.tempcat nofs;
tdef newtemp1 des='Four per page'
   1/llx=0 lly=51
     ulx=0 uly=100
     urx=49 ury=100
     lrx=49 lry=51
     color=white
   2/llx=51 lly=51
     ulx=51 uly=100
     urx=100 ury=100
     lrx=100 lry=51
     color=white
   3/llx=0 lly=0
     ulx=0 uly=49
     urx=49 ury=49
     lrx=49 lry=0
     color=white
   4/llx=51 lly=0
     ulx=51 uly=49
     urx=100 ury=49
     lrx=100 lry=0
     color=white;

   template= newtemp1;

   %setup4graphs;
run; quit;


*******************************************
* This prints multiple graphs on a single *
*  sheet (8 graphs per page), print in    *
*  portrait format.                       *
*******************************************;

*This makes sure we print the correct number of graphs;
%macro setup8graphs;
    %if (&numlevels LE 7) %then %do;
        treplay 1:Template  2:Templat1;
	%end;
    %else %if (&numlevels LE 11) %then %do;
        treplay 1:Template  2:Templat1;
		treplay 1:Templat2;
	%end;
	%else %if (&numlevels LE 15) %then %do;
        treplay 1:Template  2:Templat1;
		treplay 1:Templat2  2:Templat3;
	%end;
%mend;

*This prints the graphs;
proc greplay igout=work.gseg tc=work.tempcat nofs;
tdef newtemp2 des='Two per page'
   1/llx=0 lly=50.5
     ulx=0 uly=100
     urx=100 ury=100
     lrx=100 lry=50.5
     color=white
   2/llx=0 lly=0
     ulx=0 uly=49.5
     urx=100 ury=49.5
     lrx=100 lry=0
     color=white;

   template = newtemp2;

   %setup8graphs;
run; quit;
run; quit;
